# This is an illustration of how to implement Empirical Likelihood estimation of a quantile regression model
# see Kostov, P. (2012) Empirical likelihood estimation of the spatial quantile regression, 
# Journal of Geographical Systems, http://dx.doi.org/10.1007/s10109-012-0162-3

#source("N:/My Documents/Papers/In progress/EL-QR/SEL-SQR.r")
# contains EL functions.
#I just add the used ones below
Gu = function(u)
{
    # CDF (based on kernel Ku)
    u = pmin(u, sqrt(5))
    3/(4*sqrt(5))*(u - u^3/15 + 2*sqrt(5)/3)*(abs(u)<=sqrt(5))
}
psi.h = function(u, hn, tau)
{
    # the smoothed quantile score function
    # unsmoothed when hn=0, out = I(u<0) - tau
    if(hn==0) out = 1*(u<0) - tau
    if(hn>0) out = 1-Gu(u/hn) - tau
    return(out)
}



source("N:/My Documents/Papers/In progress/EL-QR/JGSY/IVRQ.r")
#contains code for IVQR estimation

# in fact  most of the code in the other two files may not be needed.
# The illustration below only uses  two auxiliary functions Gu(.) and psi.h(.)
# from the first file above
# and the IVQR for computing starting values. 
# Since the latter can be done alternatively (see details below) 
# only the functions   Gu(.) and psi.h(.) (used in smoothing the quantile moment conditions)
# are in fact needed 

# the example relies on availability  of EL fitting routine (in this case in the gmm package)
# if this is not the case the corresponding routines in SEL-SQR.r will need to be modified
# and translated into the type of language (other than R) that one is using


# The next section of code contains some routines for  creating artificial data
# ignore if using real data
##################################################################################
##################################################################################
make.nb= function (n) {
rc=sample.int(n,n,replace=F)
nb= matrix(rc, 10,n/10)
nb
 }

make.rook2=function(nb){
n=nrow(nb)*ncol(nb)
rook=matrix(rep(0,n^2),nrow=n, ncol=n)
####
for (i in 1:10){
    for (j in 1:(n/10)){

     if (j<n/10){
      rook[nb[i,j],nb[i,(j+1)]]<-1
      rook[nb[i,(j+1)],nb[i,j]]<-1
                    }

      if (j>1){
      rook[nb[i,j],nb[i,(j-1)]]<-1
      rook[nb[i,(j-1)],nb[i,j]]<-1
                 }

       if (i<10){
       rook[nb[i,j],nb[(i+1),j]]<-1
       rook[nb[(i+1),j],nb[i,j]]<-1
                    }

       if (i>1){
       rook[nb[i,j],nb[(i-1),j]]<-1
       rook[nb[(i-1),j],nb[i,j]]<-1
                    }
     }
}
require(spdep)
mlist=mat2listw(rook)
nb1=mlist$neighbours
wlist=nb2listw(nb1, style="W")
wlist
}


sim.norm.y= function(n,W){

v= runif(n) #innovations
x0= rnorm(n)
# now get ff
ff=qnorm(v)
# ff=qt(v,3)
#ff=qchisq(p, 3)

lambda = 0.5 + 0.1 *ff
b1=2+0.5*ff
b2=1+0.5*ff
b1+b2*x0   -> yy
II=diag(n)
IM= II-lambda*W
y=solve(IM)%*%yy
param=cbind(lambda, b1, b2)
mdat=x0
list(y,param,mdat)
}
##################################################################################
##################################################################################

# for illustration let us create some artificial data 
###################################
set.seed(123)  #fix the seed to aloow replication
n=200
nb=make.nb(n)
wlist=make.rook2(nb)
W=listw2mat(wlist)
res=sim.norm.y(n,W)
param=res[[2]]
y=res[[1]]
x0=res[[3]]

# now 
# y is the dependent variable
# x0 is the independent variable (can be more than 1)
# W is the spatial weighting matrix


Z=  lag.listw(wlist,x0,zero.policy=T) #if more than 1 vars, use  loop
res1=lag.listw(wlist,y,zero.policy=T)

# res1 is the spatially lagged dependent variable (can be more than 1)

# To do EL estimation itis better to have some starting values
# below IVQR is used to obtainn these
#  a gmm estimation can be used instead (in particular if there is mopre than 1 endogenoous variable)
# see details below
bhat=fit.ivrq(res1,x0,Z,y,tau=0.5)
#se.ivrq (bhat,res1,x0,Z,y,tau=0.5)
est.coef=bhat[c(3,1,2)] # rearrange because the gel routines uses different order for the parameters 

# elqr
# It is simpler to use an already available GEL routine
# alternatively one can manually optimise the relevant function
# see inside SEL-SQR.r

require(gmm)
# modify the  smothened moments generation function to fit your problem (mainly in terms of dimensions)
g <- function(theta, X) {
e =(X[,1]- rep(theta[1],nrow(X))-X[,2:3]%*%theta[2:3])
E= psi.h(e, hn=n^(-0.25), tau=0.5)
gmat <- cbind(E, E*c(X[,3]), E*c(X[,4]))
gmat
}
X <- as.matrix(cbind(y, res1,x0,Z))
# things to change
# 1. dimension
# 2. smoothing bandwith (if desired). The present one is data dependent, but requires that 
# the number of observations (n) is pre-defined. Can define it inside the function, if preferred
##################################################################################
##################################################################################

#if you prefer gmm for starting values
g0 <- function(theta, X) {
e =(X[,1]- rep(theta[1],nrow(X))-X[,2:3]%*%theta[2:3])
E= psi.h(e, hn=1, tau=0.5)
gmat <- cbind(E, E*c(X[,3]), E*c(X[,4]))
gmat
}
X0 <- as.matrix(cbind(y, res1,x0,Z))

m0 <-gmm(g0, x=X0,t0 = rep(0,3))
est.coef0=m0$coefficients
############################
# then  just send the estimation suing any set of starting values
m1 <-gel(g, x=X, tet0= est.coef, gradv = NULL, smooth = F, type = "EL",optlam="numeric",maxiterlam = 200)
m2<- gel(g, x=X, tet0= est.coef0, gradv = NULL, smooth = F, type = "EL",optlam="numeric",maxiterlam = 200)

# compare these if necessary
# also check the convergence codes
# if necessary  change options to achive convergence


# The above estimation does not take into account the spatial dependence. 
# It is still consistent and can be used for point estimates  
##################################################################################
##################################################################################
# for Blocking scheme, it is not possible to provide  a generic one. 
# The type of blocking will depend on the data used and will need to be done manually.
# here is an example  
# it is a naive one, because it does not apply edge correction (so it also samples observations on the boundary)

##################################
#do the blocks

n.row <- 10
n.block <- 2

blk.size <- n.row / n.block
B <- array(0, c(blk.size,blk.size,n.block^2))
k <- 1
for(i in 1:n.block){
   for(j in 1:n.block){
      B[,,k] <- nb[(1+(i-1)*blk.size):(i*blk.size),
         (1+(j-1)*blk.size):(j*blk.size)]
      k <- k+1
}}

i.samp <- sample(1:n.block^2, replace = TRUE)

Ct <- matrix(0, nrow = n.row, ncol = n.row)
k <- 1
for(i in 1:n.block){
   for(j in 1:n.block){
      Ct[(1+(i-1)*blk.size):(i*blk.size),
         (1+(j-1)*blk.size):(j*blk.size)] <- B[,,i.samp[k]]
      k <- k+1
}}

#print(C <- t(Ct))

blocks <- array(0, c(blk.size,blk.size,n.block^2))
   k <- 1
   for(i in 1:n.block){
      for(j in 1:n.block){
         blocks[,,k] <- nb[(1+(i-1)*blk.size):(i*blk.size),
            (1+(j-1)*blk.size):(j*blk.size)]
         k <- k+1
}}

block.samp <- function(n.block, blocks){
   i.samp <- sample(1:n.block^2, replace = TRUE)
   Ct <- matrix(0, nrow = n.row, ncol = n.row)
   k <- 1
   blk.size <- n.row / n.block
   for(i in 1:n.block){
      for(j in 1:n.block){
         Ct[(1+(i-1)*blk.size):(i*blk.size),
            (1+(j-1)*blk.size):(j*blk.size)] <- blocks[,,i.samp[k]]
         k <- k+1
   }}
   return(t(Ct))
}


m.blocks=function(n.block, blocks){
sel1=as.vector(block.samp(n.block, blocks))
mx=colMeans(X[sel1,])
mx
}

U <- replicate(100, m.blocks(n.block, blocks))
myx=t(U)

#estimate with the two different sets of starting values

m3 <-gel(g, x=myx, tet0= est.coef, gradv = NULL, smooth = F, type = "EL",optlam="numeric",maxiterlam = 200)
m4 <-gel(g, x=myx, tet0= est.coef0, gradv = NULL, smooth = F, type = "EL",optlam="numeric",maxiterlam = 200)

#############################

